// 全局变量
let movieData = null;

// 可以删除不再使用的downloadSubtitle函数，因为我们将使用<a>标签直接下载
let groupItems = [];
let currentVideoIndex = 0;
let customFieldData = {
    storeSiteAlias: '',
    customClassText: ''
};
let serverConfig = {
    ip: '127.0.0.1',
    port: '5280,5281'
};
let clientId = localStorage.getItem('jeenpiClientID') || '';

// 检测系统类型
function detectOS() {
    const userAgent = navigator.userAgent || navigator.vendor || window.opera;
    
    if (/Mac OS X/i.test(userAgent) && !/iPhone|iPad|iPod/i.test(userAgent)) {
        return 'macOS';
    } else if (/iPhone|iPad|iPod/i.test(userAgent)) {
        return 'iOS';
    } else if (/Android/i.test(userAgent)) {
        return 'Android';
    } else if (/Windows/i.test(userAgent)) {
        return 'Windows';
    } else if (/Linux/i.test(userAgent)) {
        return 'Linux';
    }
    return 'Unknown';
}

const currentOS = detectOS();

// DOM元素
const errorDialog = document.getElementById('errorDialog');
const errorDialogTitle = document.getElementById('errorDialogTitle');
const errorDialogMessage = document.getElementById('errorDialogMessage');
const closeErrorDialog = document.getElementById('closeErrorDialog');
const playerDialog = document.getElementById('playerDialog');
const playerDialogHint = document.getElementById('playerDialogHint');
const playerOptions = document.getElementById('playerOptions');
const useInternalPlayer = document.getElementById('useInternalPlayer');
const closePlayerDialog = document.getElementById('closePlayerDialog');
const loadingIndicator = document.getElementById('loadingIndicator');
const movieDetailContent = document.getElementById('movieDetailContent');
const errorState = document.getElementById('errorState');
const backBtn = document.getElementById('backBtn');
const homeBtn = document.getElementById('homeBtn');
const retryBtn = document.getElementById('retryBtn');
const playLoading = document.getElementById('playLoading');
const videoPlayerContainer = document.getElementById('videoPlayerContainer');
const moviePlayer = document.getElementById('moviePlayer');
const playerLoading = document.getElementById('playerLoading');

// 初始化页面
function initPage() {
    hideErrorDialog();
    hidePlayerDialog();
    
    const savedConfig = localStorage.getItem('jeenpiServerConfig');
    if (savedConfig) {
        serverConfig = JSON.parse(savedConfig);
    }
    
    clientId = localStorage.getItem('ClientID') || clientId;
    
    closeErrorDialog.addEventListener('click', hideErrorDialog);
    errorDialog.addEventListener('click', (e) => {
        if (e.target === errorDialog) hideErrorDialog();
    });
    
    closePlayerDialog.addEventListener('click', hidePlayerDialog);
    useInternalPlayer.addEventListener('click', () => {
        hidePlayerDialog();
        playMovieInternal();
    });
    
    playerDialog.addEventListener('click', (e) => {
        if (e.target === playerDialog) hidePlayerDialog();
    });
    
    // 从localStorage获取电影数据和自动播放标志
    const selectedMovie = localStorage.getItem('selectedMovie');
    const autoPlayStr = localStorage.getItem('movieAutoPlay');
    const autoPlay = autoPlayStr === 'true';
    
    // 获取数据后立即从localStorage中移除，避免重复使用
    localStorage.removeItem('selectedMovie');
    localStorage.removeItem('movieAutoPlay');
    
    if (selectedMovie) {
        try {
            movieData = JSON.parse(selectedMovie);
            fetchCustomFieldValues().then(() => {
                if (movieData.FileData?.GroupID && movieData.FileData.GroupID !== '') {
                    fetchGroupItems().then(() => {
                        if (groupItems.length > 0) {
                            currentVideoIndex = 0;
                            movieData = groupItems[0];
                            fetchCustomFieldValues().then(() => {
                                renderMovieDetail();
                                
                                // 如果需要自动播放，在渲染完成后触发播放
                                if (autoPlay) {
                                    setTimeout(() => {
                                        const playBtn = document.getElementById('playBtn');
                                        if (playBtn) {
                                            playBtn.click();
                                        }
                                    }, 100); // 短暂延迟确保DOM已完全渲染
                                }
                            });
                        } else {
                            renderMovieDetail();
                            
                            // 如果需要自动播放，在渲染完成后触发播放
                            if (autoPlay) {
                                setTimeout(() => {
                                    const playBtn = document.getElementById('playBtn');
                                    if (playBtn) {
                                        playBtn.click();
                                    }
                                }, 100); // 短暂延迟确保DOM已完全渲染
                            }
                        }
                    }).catch(() => {
                        renderMovieDetail();
                        
                        // 如果需要自动播放，在渲染完成后触发播放
                        if (autoPlay) {
                            setTimeout(() => {
                                const playBtn = document.getElementById('playBtn');
                                if (playBtn) {
                                    playBtn.click();
                                }
                            }, 100); // 短暂延迟确保DOM已完全渲染
                        }
                    });
                } else {
                    renderMovieDetail();
                    
                    // 如果需要自动播放，在渲染完成后触发播放
                    if (autoPlay) {
                        setTimeout(() => {
                            const playBtn = document.getElementById('playBtn');
                            if (playBtn) {
                                playBtn.click();
                            }
                        }, 100); // 短暂延迟确保DOM已完全渲染
                    }
                }
            }).catch(() => {
                renderMovieDetail();
                
                // 如果需要自动播放，在渲染完成后触发播放
                if (autoPlay) {
                    setTimeout(() => {
                        const playBtn = document.getElementById('playBtn');
                        if (playBtn) {
                            playBtn.click();
                        }
                    }, 100); // 短暂延迟确保DOM已完全渲染
                }
            });
        } catch (error) {
            showErrorState();
        }
    } else {
        // 如果localStorage中没有数据，显示错误状态
        showErrorState();
    }
    
    backBtn.addEventListener('click', () => window.history.back());
    homeBtn.addEventListener('click', () => window.location.href = 'index.html');
    retryBtn.addEventListener('click', () => {
        // 直接返回首页，让用户重新选择影片
        window.location.href = 'index.html';
    });
    
    moviePlayer.addEventListener('loadedmetadata', () => {
        playerLoading.classList.add('hidden');
    });
    
    moviePlayer.addEventListener('error', (e) => {
        playerLoading.classList.add('hidden');
        if (videoPlayerContainer.classList.contains('hidden') === false) {
            showErrorDialog('播放失败', getVideoErrorText(e.target.error));
        }
    });
}

function showErrorDialog(title, message) {
    errorDialogTitle.textContent = title;
    errorDialogMessage.textContent = message;
    errorDialog.classList.add('show');
}

function hideErrorDialog() {
    errorDialog.classList.remove('show');
}

function showPlayerDialog(videoUrl) {
    let osName = '';
    let players = [];
    
    if (currentOS === 'macOS') {
        osName = 'macOS';
        players = [
            { name: 'IINA', scheme: 'iina://weblink?url=', icon: 'fa-film' }
        ];
    } else if (currentOS === 'iOS') {
        osName = 'iOS';
        players = [
            { name: 'VLC', scheme: 'vlc-x-callback://x-callback-url/stream?url=', icon: 'fa-play-circle' },
            { name: 'nPlayer', scheme: 'nplayer-', icon: 'fa-film' }
        ];
    } else if (currentOS === 'Android') {
        osName = 'Android';
        players = [
            { name: 'VLC', scheme: 'vlc://', icon: 'fa-play-circle' },
            { name: 'MX Player', scheme: 'intent:', icon: 'fa-film' }
        ];
    } else if (currentOS === 'Windows') {
        osName = 'Windows';
        players = [
            { name: 'PotPlayer', scheme: 'potplayer://', icon: 'fa-play-circle' },
            { name: 'VLC', scheme: 'vlc-x-callback://x-callback-url/stream?url=', icon: 'fa-play-circle' }
        ];
    } else {
        // 其他系统默认添加PotPlayer和VLC
        osName = '其他操作系统';
        players = [
            { name: 'PotPlayer', scheme: 'potplayer://', icon: 'fa-play-circle' },
            { name: 'VLC', scheme: 'vlc-x-callback://x-callback-url/stream?url=', icon: 'fa-play-circle' }
        ];
    }
    
    playerDialogHint.textContent = `检测到您使用的是 ${osName} 系统，推荐使用外部播放器获得更好的体验`;
    
    // 获取字幕URL（如果存在）
    let subtitleUrl = '';
    let subtitleExtension = '';
    if (movieData.SubtitleURL || movieData.Subtitles) {
        const resourcePort = serverConfig.port.split(',')[1] || '5281';
        const subtitlePath = movieData.SubtitleURL || movieData.Subtitles;
        
        if (subtitlePath.startsWith('http')) {
            subtitleUrl = subtitlePath;
        } else {
            subtitleUrl = `http://${serverConfig.ip}:${resourcePort}${subtitlePath}`;
        }
        
        // 提取字幕文件扩展名
        const lastDotIndex = subtitlePath.lastIndexOf('.');
        if (lastDotIndex > -1) {
            subtitleExtension = subtitlePath.substring(lastDotIndex);
        }
    }
    

    
    // 对于Android设备，使用更简单直接的HTML实现
    if (currentOS === 'Android') {
        playerOptions.innerHTML = `
            <div class="space-y-3">
                <a href="vlc://${encodeURIComponent(videoUrl)}" class="player-option w-full py-3 px-4 bg-white border-2 border-gray-200 rounded-lg hover:border-primary hover:bg-blue-50 transition-all text-left flex items-center block">
                    <i class="fa fa-play-circle text-primary text-2xl mr-3"></i>
                    <div class="flex-1">
                        <div class="font-medium text-gray-900">VLC</div>
                        <div class="text-xs text-gray-500">使用VLC打开播放</div>
                    </div>
                    <i class="fa fa-chevron-right text-gray-400"></i>
                </a>
                <a href="intent:${encodeURIComponent(videoUrl)}#Intent;action=android.intent.action.VIEW;type=video/*;end" class="player-option w-full py-3 px-4 bg-white border-2 border-gray-200 rounded-lg hover:border-primary hover:bg-blue-50 transition-all text-left flex items-center block">
                    <i class="fa fa-film text-primary text-2xl mr-3"></i>
                    <div class="flex-1">
                        <div class="font-medium text-gray-900">MX Player</div>
                        <div class="text-xs text-gray-500">使用MX Player打开播放</div>
                    </div>
                    <i class="fa fa-chevron-right text-gray-400"></i>
                </a>
                ${subtitleUrl ? `<a href="${subtitleUrl}" download target="_blank" class="player-option w-full py-2 px-3 bg-white border-1 border-gray-200 rounded-lg hover:border-primary hover:bg-blue-50 transition-all text-left flex items-center justify-between block">
                    <div class="flex items-center">
                        <i class="fa fa-download text-green-500 text-lg mr-2"></i>
                        <span class="text-xs text-gray-500">包含字幕文件(${subtitleExtension || '.ass'})</span>
                    </div>
                    <span class="font-medium text-gray-600 text-sm">下载字幕</span>
                </a>` : ''}

            </div>
        `;
        

    } else {
        // 构建播放器选项HTML
        let playerOptionsHtml = '';
        
        // 添加播放器选项
        playerOptionsHtml += players.map(player => `
            <button class="player-option w-full py-3 px-4 bg-white border-2 border-gray-200 rounded-lg hover:border-primary hover:bg-blue-50 transition-all text-left flex items-center" data-player="${player.name}" data-scheme="${player.scheme}">
                <i class="fa ${player.icon} text-primary text-2xl mr-3"></i>
                <div class="flex-1">
                    <div class="font-medium text-gray-900">${player.name}</div>
                    <div class="text-xs text-gray-500">使用 ${player.name} 打开播放</div>
                </div>
                <i class="fa fa-chevron-right text-gray-400"></i>
            </button>
        `).join('');
        
        // 如果有字幕，添加下载按钮
            if (subtitleUrl) {
                playerOptionsHtml += `
                 <a href="${subtitleUrl}" download target="_blank" class="player-option w-full py-2 px-3 bg-white border-1 border-gray-200 rounded-lg hover:border-primary hover:bg-blue-50 transition-all text-left flex items-center justify-between">
                    <div class="flex items-center">
                        <i class="fa fa-download text-green-500 text-lg mr-2"></i>
                        <span class="text-xs text-gray-500">包含字幕文件(${subtitleExtension || '.ass'})</span>
                    </div>
                    <span class="font-medium text-gray-600 text-sm">下载字幕</span>
                </a>
            `;
            }
        
        playerOptions.innerHTML = playerOptionsHtml;
        

        
        // 为播放器选项添加事件监听
        document.querySelectorAll('.player-option').forEach(btn => {
            btn.addEventListener('click', function() {
                const playerName = this.dataset.player;
                const scheme = this.dataset.scheme;
                openExternalPlayer(videoUrl, scheme, playerName);
            });
        });
    }
    
    playerDialog.classList.add('show');
}

function hidePlayerDialog() {
    playerDialog.classList.remove('show');
}

function openExternalPlayer(videoUrl, scheme, playerName) {
    let finalUrl = '';
    
    // 获取字幕URL（如果存在）
    let subtitleUrl = '';
    let subtitleExtension = '';
    if (movieData.SubtitleURL || movieData.Subtitles) {
        const resourcePort = serverConfig.port.split(',')[1] || '5281';
        const subtitlePath = movieData.SubtitleURL || movieData.Subtitles;
        
        if (subtitlePath.startsWith('http')) {
            subtitleUrl = subtitlePath;
        } else {
            subtitleUrl = `http://${serverConfig.ip}:${resourcePort}${subtitlePath}`;
        }
        
        // 提取字幕文件扩展名
        const lastDotIndex = subtitlePath.lastIndexOf('.');
        if (lastDotIndex > -1) {
            subtitleExtension = subtitlePath.substring(lastDotIndex);
        }
    }
    
    // 根据不同播放器构建 URL Scheme - 只保留视频URL和字幕URL
    if (currentOS === 'Android' && playerName === 'MX Player') {
        // MX Player - 简化格式，只保留视频URL
        const packageName = "com.mxtech.videoplayer.ad";
        finalUrl = `intent:${encodeURI(videoUrl)}#Intent;package=${packageName};end`;
    } else if (playerName === 'VLC') {
        // VLC - 不同平台的简化格式
        if (currentOS === 'macOS') {
            // macOS下使用标准的vlc://格式
            finalUrl = `vlc://${encodeURI(videoUrl)}`;
            if (subtitleUrl) {
                finalUrl += `?subtitles=${encodeURI(subtitleUrl)}`;
            }
        } else if (currentOS === 'Android') {
            // Android上VLC使用Intent格式
            finalUrl = `intent:${encodeURI(videoUrl)}#Intent;package=org.videolan.vlc;type=video/*;end`;
        } else {
            // 其他平台使用vlc-x-callback格式
            finalUrl = `vlc-x-callback://x-callback-url/stream?url=${encodeURI(videoUrl)}`;
            if (subtitleUrl) {
                finalUrl += `&sub=${encodeURI(subtitleUrl)}`;
            }
        }
    } else if (playerName === 'PotPlayer') {
        // PotPlayer - 简化格式，使用基本的URL Scheme
        finalUrl = `potplayer://${encodeURI(videoUrl)}`;
        if (subtitleUrl) {
            finalUrl += ' /sub=' + encodeURI(subtitleUrl);
        }
    } else if (currentOS === 'iOS' && playerName === 'nPlayer') {
        // nPlayer - 简化格式
        finalUrl = `nplayer-${encodeURI(videoUrl)}`;
        if (subtitleUrl) {
            const separator = videoUrl.includes('?') ? '&' : '?';
            finalUrl = `nplayer-${encodeURI(videoUrl)}${separator}subtitle=${encodeURI(subtitleUrl)}`;
        }
    } else if (playerName === 'IINA') {
        // IINA播放器 - 简化格式
        finalUrl = `iina://weblink?url=${encodeURI(videoUrl)}`;
        if (subtitleUrl) {
            finalUrl += `&mpv_sub-files=${encodeURI(subtitleUrl)}`;
        }
    } else {
        // 其他播放器默认处理
        finalUrl = scheme + encodeURI(videoUrl);
        if (subtitleUrl) {
            // 尝试添加字幕参数（具体格式可能需要根据播放器调整）
            finalUrl += '?subtitle=' + encodeURI(subtitleUrl);
        }
    }
    
    // 尝试打开外部播放器
    
    // 不再需要为macOS上的VLC准备备用URL格式
    
    // 改进的检测机制
    let hasLeftPage = false;
    let hasBlurred = false;
    const startTime = Date.now();
    let checkTimer = null;
    
    // 监听页面可见性变化（App切换）
    const visibilityHandler = () => {
        if (document.hidden) {
            hasLeftPage = true;
        }
    };
    document.addEventListener('visibilitychange', visibilityHandler);
    
    // 监听页面失焦（App切换）
    const blurHandler = () => {
        hasBlurred = true;
    };
    window.addEventListener('blur', blurHandler);
    
    // 监听页面重新获得焦点
    const focusHandler = () => {
        // 如果之前已经失焦或隐藏，说明确实打开了外部应用
        if (hasBlurred || hasLeftPage) {
            clearTimeout(checkTimer);
            cleanup();
            hidePlayerDialog();
            // 不显示任何提示，因为已经成功

        }
    };
    window.addEventListener('focus', focusHandler);
    
    // 清理函数
    const cleanup = () => {
        document.removeEventListener('visibilitychange', visibilityHandler);
        window.removeEventListener('blur', blurHandler);
        window.removeEventListener('focus', focusHandler);
        if (link && link.parentNode) {
            document.body.removeChild(link);
        }
        // 备用链接会在各自的try/catch块中被清理
    };
    
    // 尝试打开 - 针对PotPlayer特殊处理以避免竖线符号被编码
    try {
        // 对于PotPlayer，我们需要特殊处理竖线符号
        if (playerName === 'PotPlayer') {

            
            // 使用更简单的方式：直接设置window.location
            window.location.href = finalUrl;
        } else {
            // 其他播放器使用常规方法

            window.open(finalUrl, '_self');
        }
    } catch (e) {
        // 备用方案：使用a标签点击
        const link = document.createElement('a');
        link.href = finalUrl;
        link.style.display = 'none';
        document.body.appendChild(link);
        link.click();
        setTimeout(() => {
            if (link.parentNode) {
                document.body.removeChild(link);
            }
        }, 100);
    }
    
    // 使用更长的超时时间进行检测（3秒）
    checkTimer = setTimeout(() => {
        const elapsedTime = Date.now() - startTime;
        
        // 如果页面失焦或隐藏过，认为可能成功
        if (hasLeftPage || hasBlurred) {

            cleanup();
            hidePlayerDialog();
            // 成功时不显示提示，用户体验更好
        } else {
            // 其他情况，显示错误

            cleanup();
            hidePlayerDialog();
            showErrorDialog(
                '无法打开播放器', 
                `未能打开 ${playerName} 应用。请确认：\n1. 已安装 ${playerName} 应用\n2. 已授予必要的权限\n\n您可以选择使用内置播放器播放。`
            );
        }
    }, 3000);
}

function getVideoErrorText(error) {
    switch(error.code) {
        case error.MEDIA_ERR_ABORTED:
            return "视频加载被中止，请重试。";
        case error.MEDIA_ERR_NETWORK:
            return "网络错误导致视频加载失败，请检查网络连接后重试。";
        case error.MEDIA_ERR_DECODE:
            return "视频文件损坏或格式不支持，无法播放。";
        case error.MEDIA_ERR_SRC_NOT_SUPPORTED:
            return "影片文件不存在或无法访问，无法播放！";
        default:
            return "播放过程中发生未知错误，请尝试其他影片。";
    }
}

async function playMovie() {
    if (!movieData || !movieData.FileData) {
        showErrorDialog('播放失败', '无法获取影片信息，无法播放！');
        return;
    }
    
    playLoading.classList.remove('hidden');
    playLoading.classList.add('flex');
    
    try {
        const pid = movieData.FileData.AID;
        const fileName = movieData.FileData.FileName;
        const storeSite = movieData.FileData.StoreSite;
        
        if (!pid || !fileName || !storeSite) {
            throw new Error('影片信息不完整，无法播放！');
        }
        
        const paramsDataObj = {
            "PID": pid,
            "FileName": fileName,
            "StoreSite": storeSite
        };
        
        const jsonStr = JSON.stringify(paramsDataObj);
        const base64Params = base64Encode(jsonStr);
        
        const formData = new FormData();
        formData.append('AppKey', 'B623D8449570');
        formData.append('ClientID', clientId);
        formData.append('ParamsData', base64Params);
        
        const apiPort = serverConfig.port.split(',')[0] || '5280';
        const url = `http://${serverConfig.ip}:${apiPort}/JeenpiAPI/V1/PlayMovieDirectly`;
        
        const response = await fetch(url, {
            method: 'POST',
            body: formData
        });
        
        const encodedResponse = await response.text();
        const data = JSON.parse(encodedResponse);
        
        playLoading.classList.add('hidden');
        playLoading.classList.remove('flex');
        
        if (data.code && data.code > 0) {
            let errorMsg = data.msg || `播放请求失败，错误代码: ${data.code}`;
            
            if (data.code === 404) {
                errorMsg = "影片文件不存在，无法播放！";
            } else if (data.code === 403) {
                errorMsg = "您没有权限播放此影片。";
            } else if (data.code >= 500) {
                errorMsg = "服务器错误，请稍后再试。";
            }
            
            throw new Error(errorMsg);
        }
        
        if (data.Data && data.Data.URLFileName) {
            const videoUrl = `http://${serverConfig.ip}:${serverConfig.port.split(',')[1] || '5281'}${data.Data.URLFileName}`;
            
            // 保存字幕URL（从Subtitles字段获取）
            if (data.Data.Subtitles) {
                movieData.SubtitleURL = data.Data.Subtitles;
            }
            
            // 对所有系统都显示播放器选择对话框，让用户自行选择使用哪个播放器
            showPlayerDialog(videoUrl);
        } else {
            throw new Error('未获取到有效的播放链接，无法播放！');
        }
    } catch (error) {
        playLoading.classList.add('hidden');
        playLoading.classList.remove('flex');
        showErrorDialog('播放失败', error.message);
    }
}

async function playMovieInternal() {
    if (!movieData || !movieData.FileData) {
        showErrorDialog('播放失败', '无法获取影片信息，无法播放！');
        return;
    }
    
    playLoading.classList.remove('hidden');
    playLoading.classList.add('flex');
    
    try {
        const pid = movieData.FileData.AID;
        const fileName = movieData.FileData.FileName;
        const storeSite = movieData.FileData.StoreSite;
        
        if (!pid || !fileName || !storeSite) {
            throw new Error('影片信息不完整，无法播放！');
        }
        
        const paramsDataObj = {
            "PID": pid,
            "FileName": fileName,
            "StoreSite": storeSite
        };
        
        const jsonStr = JSON.stringify(paramsDataObj);
        const base64Params = base64Encode(jsonStr);
        
        const formData = new FormData();
        formData.append('AppKey', 'B623D8449570');
        formData.append('ClientID', clientId);
        formData.append('ParamsData', base64Params);
        
        const apiPort = serverConfig.port.split(',')[0] || '5280';
        const url = `http://${serverConfig.ip}:${apiPort}/JeenpiAPI/V1/PlayMovieDirectly`;
        
        const response = await fetch(url, {
            method: 'POST',
            body: formData
        });
        
        const encodedResponse = await response.text();
        const data = JSON.parse(encodedResponse);
        
        playLoading.classList.add('hidden');
        playLoading.classList.remove('flex');
        
        if (data.code && data.code > 0) {
            let errorMsg = data.msg || `播放请求失败，错误代码: ${data.code}`;
            
            if (data.code === 404) {
                errorMsg = "影片文件不存在，无法播放！";
            } else if (data.code === 403) {
                errorMsg = "您没有权限播放此影片。";
            } else if (data.code >= 500) {
                errorMsg = "服务器错误，请稍后再试。";
            }
            
            throw new Error(errorMsg);
        }
        
        if (data.Data && data.Data.URLFileName) {
                const videoUrl = `http://${serverConfig.ip}:${serverConfig.port.split(',')[1] || '5281'}${data.Data.URLFileName}`;
                
                // 保存字幕URL（从Subtitles字段获取）
                if (data.Data.Subtitles) {
                    movieData.SubtitleURL = data.Data.Subtitles;
                }
                
                // 直接使用内置播放器播放
                playWithInternalPlayer(videoUrl);
            } else {
                throw new Error('未获取到有效的播放链接，无法播放！');
            }
    } catch (error) {
        playLoading.classList.add('hidden');
        playLoading.classList.remove('flex');
        showErrorDialog('播放失败', error.message);
    }
}

async function playWithInternalPlayer(videoUrl) {
    videoPlayerContainer.classList.remove('hidden');
    playerLoading.classList.remove('hidden');
    
    movieData.currentVideoUrl = videoUrl;
    moviePlayer.src = videoUrl;
    
    // 添加字幕支持（如果存在）
    if (movieData.SubtitleURL) {
        const resourcePort = serverConfig.port.split(',')[1] || '5281';
        let subtitleUrl = movieData.SubtitleURL;
        
        // 如果字幕URL不是完整URL，则补全
        if (!subtitleUrl.startsWith('http')) {
            subtitleUrl = `http://${serverConfig.ip}:${resourcePort}${subtitleUrl}`;
        }
        
        // 清除旧的字幕轨道
        const oldTracks = moviePlayer.querySelectorAll('track');
        oldTracks.forEach(track => track.remove());
        
        // 添加新的字幕轨道
        const track = document.createElement('track');
        track.kind = 'subtitles';
        track.label = '中文';
        track.srclang = 'zh';
        track.src = subtitleUrl;
        track.default = true;
        moviePlayer.appendChild(track);
        

    }
    
    moviePlayer.load();
    
    try {
        await moviePlayer.play();
    } catch (playError) {}
    
    videoPlayerContainer.scrollIntoView({ behavior: 'smooth' });
}



function formatDuration(seconds) {
    if (!seconds || isNaN(seconds)) return '未知时长';
    
    const totalSeconds = Math.floor(Number(seconds));
    const hours = Math.floor(totalSeconds / 3600);
    const minutes = Math.floor((totalSeconds % 3600) / 60);
    const secs = totalSeconds % 60;
    
    const formattedHours = hours.toString().padStart(2, '0');
    const formattedMinutes = minutes.toString().padStart(2, '0');
    const formattedSeconds = secs.toString().padStart(2, '0');
    
    return hours > 0 
        ? `${formattedHours}:${formattedMinutes}:${formattedSeconds}`
        : `${formattedMinutes}:${formattedSeconds}`;
}

const chineseNumbers = {
    '零': 0, '一': 1, '二': 2, '三': 3, '四': 4,
    '五': 5, '六': 6, '七': 7, '八': 8, '九': 9,
    '十': 10, '百': 100, '千': 1000, '万': 10000
};

function chineseToNumber(chinese) {
    if (!chinese || typeof chinese !== 'string') return 0;
    
    const numMatch = chinese.match(/\d+/);
    if (numMatch) return parseInt(numMatch[0], 10);
    
    let result = 0;
    let temp = 0;
    
    for (let i = 0; i < chinese.length; i++) {
        const char = chinese[i];
        const num = chineseNumbers[char];
        
        if (num === undefined) continue;
        
        if (num >= 10) {
            if (temp === 0) temp = 1;
            temp *= num;
            result += temp;
            temp = 0;
        } else {
            temp += num;
        }
    }
    
    result += temp;
    return result > 0 ? result : 0;
}

function extractSortNumber(str) {
    if (!str) return 0;
    
    const numMatch = str.match(/\d+/);
    if (numMatch) return parseInt(numMatch[0], 10);
    
    return chineseToNumber(str);
}

async function fetchCustomFieldValues() {
    const targetPid = movieData.PID;
    const targetStoreSite = movieData.FileData?.StoreSite;
        
    if (!targetPid || !targetStoreSite) {
        return;
    }
    
    try {
        const paramsDataObj = [
            {
                "Method": "GetCustomClassText",
                "PID": targetPid
            },
            {
                "Method": "GetStoreSiteCustomCaption",
                "StoreSite": targetStoreSite
            }
        ];
        
        const jsonStr = JSON.stringify(paramsDataObj);
        const base64Params = base64Encode(jsonStr);
        
        const formData = new FormData();
        formData.append('AppKey', 'B623D8449570');
        formData.append('ClientID', clientId);
        formData.append('ParamsData', base64Params);
        
        const apiPort = serverConfig.port.split(',')[0] || '5280';
        const url = `http://${serverConfig.ip}:${apiPort}/JeenpiAPI/V1/GetFieldValue`;
        
        const response = await fetch(url, {
            method: 'POST',
            body: formData
        });
        
        const encodedResponse = await response.text();
        const data = JSON.parse(encodedResponse);
        
        if (data.code && data.code > 0) {
            throw new Error(data.msg || `获取自定义字段失败，错误代码: ${data.code}`);
        }
        
        if (data.Data && Array.isArray(data.Data)) {
            data.Data.forEach(item => {
                if (item.Method === 'GetStoreSiteCustomCaption' && item.Value) {
                    customFieldData.storeSiteAlias = item.Value;
                } else if (item.Method === 'GetCustomClassText' && item.Items && item.Items.length > 0) {
                    customFieldData.customClassText = item.Items.map(i => i.Text || i.Value).join('、');
                }
            });
        }
        
    } catch (error) {}

}

async function fetchGroupItems() {
    if (!movieData || !movieData.FileData?.GroupID) {
        return;
    }
    
    try {
        const paramsDataObj = {
            "GroupID": movieData.FileData.GroupID
        };
        
        const jsonStr = JSON.stringify(paramsDataObj);
        const base64Params = base64Encode(jsonStr);
        
        const formData = new FormData();
        formData.append('AppKey', 'B623D8449570');
        formData.append('ClientID', clientId);
        formData.append('ParamsData', base64Params);
        
        const apiPort = serverConfig.port.split(',')[0] || '5280';
        const url = `http://${serverConfig.ip}:${apiPort}/JeenpiAPI/V1/GetGroupMovieItems`;
        
        const response = await fetch(url, {
            method: 'POST',
            body: formData
        });
        
        const responseText = await response.text();
        const data = JSON.parse(responseText);
        
        if (data.code && data.code > 0) {
            throw new Error(data.msg || `获取分组视频失败，错误代码: ${data.code}`);
        }
        
        if (data.Data && Array.isArray(data.Data)) {
            groupItems = data.Data;
            
            const groupKind = movieData.FileData?.GroupKind;
            if (groupKind === 0) {
                groupItems.sort((a, b) => {
                    const aFileName = a.FileData?.FileName || '';
                    const bFileName = b.FileData?.FileName || '';
                    return extractSortNumber(aFileName) - extractSortNumber(bFileName);
                });
            } else if (groupKind === 1) {
                groupItems.sort((a, b) => {
                    const aYear = parseInt(a.WebData?.year || '0', 10);
                    const bYear = parseInt(b.WebData?.year || '0', 10);
                    return aYear - bYear;
                });
            }
        }
        
    } catch (error) {
        throw error;
    }
}

function switchToGroupItem(index, playAfterSwitch = false) {
    if (!groupItems || index < 0 || index >= groupItems.length) {
        return;
    }
    
    showLoadingState();
    
    currentVideoIndex = index;
    movieData = groupItems[index];
    
    fetchCustomFieldValues().then(() => {
        renderMovieDetail();
        
        if (playAfterSwitch) {
            // 保持视频容器隐藏，让用户通过对话框选择播放方式
            videoPlayerContainer.classList.add('hidden');
            playMovie();
        } else {
            videoPlayerContainer.classList.add('hidden');
        }
    });
}

function base64Encode(str) {
    let escaped = '';
    for (let i = 0; i < str.length; i++) {
        const code = str.charCodeAt(i);
        if (code < 128) {
            escaped += str[i];
        } else {
            escaped += '\\u' + code.toString(16).padStart(4, '0');
        }
    }
    return btoa(escaped);
}

function base64Decode(encodedStr) {
    try {
        const decoded = atob(encodedStr);
        return decoded.replace(/\\u([0-9a-fA-F]{4})/g, (match, hex) => {
            return String.fromCharCode(parseInt(hex, 16));
        });
    } catch (error) {
        throw new Error('解析播放链接失败');
    }
}

async function fetchMovieDetailFromApi(pid, autoPlay = false) {
    showLoadingState();
    
    try {
        const formData = new FormData();
        formData.append('AppKey', 'B623D8449570');
        formData.append('ClientID', clientId);
        
        const paramsDataObj = {
            "PID": pid
        };
        formData.append('ParamsData', JSON.stringify(paramsDataObj));
        
        const apiPort = serverConfig.port.split(',')[0] || '5280';
        const url = `http://${serverConfig.ip}:${apiPort}/JeenpiAPI/V1/GetMovieDetail`;
        
        const response = await fetch(url, {
            method: 'POST',
            body: formData
        });
        
        const data = await response.json();
        
        if (data.code > 0) {
            throw new Error(data.msg || `获取影片详情失败，错误代码: ${data.code}`);
        }
        
        if (data.Data) {
            movieData = data.Data;
            await fetchCustomFieldValues();
            
            if (movieData.FileData?.GroupID && movieData.FileData.GroupID !== '') {
                await fetchGroupItems();
                if (groupItems.length > 0) {
                    currentVideoIndex = 0;
                    movieData = groupItems[0];
                    await fetchCustomFieldValues();
                }
            }
            
            renderMovieDetail();
            
            // 如果需要自动播放，在渲染完成后触发播放
            if (autoPlay) {
                setTimeout(() => {
                    const playBtn = document.getElementById('playBtn');
                    if (playBtn) {
                        playBtn.click();
                    }
                }, 100); // 短暂延迟确保DOM已完全渲染
            }
        } else {
            throw new Error('未找到影片详情数据');
        }
    } catch (error) {
        showErrorState();
    }
}

function generateRatingHtml(rating) {
    const score = Math.max(0, Math.min(10, parseFloat(rating) || 0));
    const fullStars = Math.floor(score / 2);
    const hasHalfStar = score % 2 >= 1;
    
    let starsHtml = '';
    
    for (let i = 0; i < fullStars; i++) {
        starsHtml += '<i class="fa fa-star text-rating"></i>';
    }
    
    if (hasHalfStar) {
        starsHtml += '<i class="fa fa-star-half-o text-rating"></i>';
    }
    
    const emptyStars = 5 - fullStars - (hasHalfStar ? 1 : 0);
    for (let i = 0; i < emptyStars; i++) {
        starsHtml += '<i class="fa fa-star-o text-rating"></i>';
    }
    
    return `
        <!-- 移动端水平布局，桌面端垂直布局 -->
        <div class="bg-yellow-50 p-3 sm:p-4 rounded-lg">
            <!-- 移动端水平布局 -->
            <div class="flex items-center justify-between sm:flex-col sm:items-center w-full">
                <div class="flex items-center">
                    <div class="text-2xl sm:text-3xl font-bold text-gray-900 mr-3">${score.toFixed(1)}</div>
                    <div class="flex">${starsHtml}</div>
                </div>
                <div class="hidden sm:block text-sm text-gray-500 my-1">影片评分</div>
                <div class="w-full mt-2 sm:mt-1 rating-bar">
                    <div class="rating-fill" style="width: ${score * 10}%"></div>
                </div>
            </div>
        </div>
    `;
}

function formatFileSize(bytes) {
    if (bytes === 0 || !bytes) return '未知大小';
    
    const units = ['B', 'KB', 'MB', 'GB', 'TB'];
    let unitIndex = 0;
    
    while (bytes >= 1024 && unitIndex < units.length - 1) {
        bytes /= 1024;
        unitIndex++;
    }
    
    return `${bytes.toFixed(2)} ${units[unitIndex]}`;
}

function mapQuality(qualityValue) {
    switch(qualityValue) {
        case 0: return 'Low';
        case 1: return '480P';
        case 2: return '720P';
        case 3: return '1080P';
        case 4: return '4K';
        default: return '未知';
    }
}

function limitAliases(aliases, maxCount = 3) {
    if (!aliases || !Array.isArray(aliases)) return [];
    
    if (typeof aliases === 'string') {
        aliases = aliases.split(',').map(a => a.trim()).filter(a => a);
    }
    
    return aliases.slice(0, maxCount);
}

function renderMovieDetail() {
    if (!movieData) {
        showErrorState();
        return;
    }
    
    const displayData = movieData;
    
    let posterUrl = displayData.PosterURL;
    const resourcePort = serverConfig.port.split(',')[1] || '5281';
    
    if (posterUrl && !posterUrl.startsWith('http')) {
        posterUrl = `http://${serverConfig.ip}:${resourcePort}${posterUrl}`;
    } else if (!posterUrl) {
        posterUrl = `https://picsum.photos/seed/${displayData.PID || 'default'}/800/1200`;
    }
    
    // 对于电视剧，使用GroupID作为标题
    const title = displayData.FileData?.GroupID && displayData.FileData.GroupID !== '' ? 
                  displayData.FileData.GroupID : 
                  (displayData.WebData?.title || displayData.FileData?.Caption || '未知影片');
    const originalTitle = displayData.WebData?.original_title || '';
    
    const aliases = limitAliases(displayData.WebData?.aliases);
    const aliasesHtml = aliases.length > 0 
        ? `<p class="text-gray-500 mt-1 truncate" title="别名: ${aliases.join(' / ')}">别名: ${aliases.join(' / ')}</p>` 
        : '';
        
    const year = displayData.WebData?.year || '未知年份';
    const countries = displayData.WebData?.countries || '';
    const genres = displayData.WebData?.genres || '';
    const directors = displayData.WebData?.directors || '未知导演';
    const casts = displayData.WebData?.casts || '未知演员';
    const rating = displayData.WebData?.rating_douban || '暂无评分';
    const summary = displayData.WebData?.summary || '暂无剧情简介';
    
    const durationSeconds = displayData.FileData?.Duration;
    const duration = formatDuration(durationSeconds);
    
    const ratingHtml = generateRatingHtml(rating);
    
    const sizeBytes = movieData.FileData?.Size;
    const size = formatFileSize(sizeBytes);
    const videoFormat = movieData.VideoFormat || '未知';
    const audioFormat = movieData.AudioFormat || '未知';
    const qualityValue = movieData.Quality;
    const quality = mapQuality(qualityValue);
    const fileLocation = displayData.FileData?.StoreSite || '未知位置';
    const displayFileLocation = customFieldData.storeSiteAlias || fileLocation;
    
    // 检查是否有字幕信息
    const hasSubtitle = displayData.Subtitles || displayData.SubtitleURL || movieData.SubtitleURL;
    const subtitleHtml = hasSubtitle 
        ? `<div class="bg-white p-4 rounded-lg shadow-sm border border-gray-100">
            <h4 class="text-sm font-medium text-gray-500 mb-2">字幕</h4>
            <p class="text-gray-800 flex items-center">
                <i class="fa fa-check-circle text-green-500 mr-2"></i>有字幕文件
            </p>
          </div>`
        : '';
    
    const labelsHtml = displayData.Labels && displayData.Labels.length > 0 
        ? `<div class="mt-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-3 flex items-center">
                <i class="fa fa-tags mr-2 text-primary"></i>标签
            </h2>
            <div class="flex flex-wrap gap-2">
                ${displayData.Labels.split(',').map(label => 
                    `<span class="bg-blue-50 text-blue-700 px-3 py-1 rounded text-sm">${label}</span>`
                ).join('')}
            </div>
          </div>` 
        : '';
    
    const customClassHtml = customFieldData.customClassText 
        ? `<div class="mt-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-3 flex items-center">
                <i class="fa fa-cubes mr-2 text-primary"></i>自定义类别
            </h2>
            <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-100">
                <p class="text-gray-700">${customFieldData.customClassText}</p>
            </div>
          </div>` 
        : '';
    
    let groupItemsHtml = '';
    const groupKind = movieData.FileData?.GroupKind;
    
    if (groupItems && groupItems.length > 0) {
        if (groupKind === 0) {
            groupItemsHtml = `<div class="mt-8">
                <h2 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                    <i class="fa fa-television mr-2 text-primary"></i>剧集列表
                </h2>
                <div class="flex flex-wrap gap-2 max-h-40 overflow-y-auto pb-2">
                    ${groupItems.map((item, index) => {
                        const displayName = item.FileData?.SubCaptionByGroup || 
                                          `${index + 1}集`;
                        
                        return `
                        <button 
                            class="episode-btn ${index === currentVideoIndex ? 'episode-btn-active' : 'episode-btn-inactive'}"
                            onclick="switchToGroupItem(${index}, true)"
                        >
                            ${displayName}
                        </button>
                    `;
                    }).join('')}
                </div>
            </div>`;
        } else if (groupKind === 1) {
            groupItemsHtml = `<div class="mt-8">
                <h2 class="text-xl font-semibold text-gray-800 mb-4 flex items-center">
                    <i class="fa fa-film mr-2 text-primary"></i>系列影片
                </h2>
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-4">
                    ${groupItems.map((item, index) => {
                        let itemPosterUrl = item.PosterURL;
                        if (itemPosterUrl && !itemPosterUrl.startsWith('http')) {
                            itemPosterUrl = `http://${serverConfig.ip}:${resourcePort}${itemPosterUrl}`;
                        } else if (!itemPosterUrl) {
                            itemPosterUrl = `https://picsum.photos/seed/${item.PID}/300/450`;
                        }
                        
                        const itemTitle = item.FileData?.SubCaptionByGroup || 
                                        item.WebData?.title || 
                                        item.FileData?.Caption || 
                                        '未知影片';
                        const itemYear = item.WebData?.year || '未知年份';
                        
                        return `
                            <div 
                                class="group cursor-pointer"
                                onclick="switchToGroupItem(${index}, false)"
                            >
                                <div class="relative rounded overflow-hidden shadow-sm">
                                    <img src="${itemPosterUrl}" alt="${itemTitle}的海报" class="w-full aspect-[2/3] object-cover transition-transform duration-300 group-hover:scale-105">
                                    ${index === currentVideoIndex ? `
                                        <div class="absolute top-2 right-2 bg-primary text-white text-xs px-2 py-1 rounded-full">
                                            当前
                                        </div>
                                    ` : ''}
                                </div>
                                <p class="mt-2 text-sm font-medium text-gray-800 truncate">${itemTitle}</p>
                                <p class="text-xs text-gray-500">${itemYear}</p>
                            </div>
                        `;
                    }).join('')}
                </div>
            </div>`;
        }
    }
    
    movieDetailContent.innerHTML = `
        <div class="md:flex gap-6">
            <div class="md:w-1/3 lg:w-1/4 mb-10 md:mb-0">
                <div class="sticky top-20">
                    <img src="${posterUrl}" alt="${title}的海报" class="w-full h-auto object-cover rounded-lg shadow-md">
                    
                    <div class="mt-6 space-y-4">
                        <button id="playBtn" class="w-full bg-primary hover:bg-primary/90 text-white font-medium py-3 px-4 rounded-lg transition-all duration-200 flex items-center justify-center">
                            <i class="fa fa-play mr-2"></i> 立即播放
                        </button>
                    </div>
                </div>
            </div>
            
            <div class="md:w-2/3 lg:w-3/4 pt-0 md:pt-0">
                <div class="flex flex-wrap gap-4">
                    <div class="flex-1 min-w-0">
                        <h1 class="text-2xl md:text-3xl font-bold text-gray-900 truncate">${title}</h1>
                        ${originalTitle ? `<p class="text-gray-500 mt-1 truncate" title="${originalTitle}">${originalTitle}</p>` : ''}
                        ${aliasesHtml}
                        <p class="text-gray-600 mt-2">${year} / ${countries} / ${duration}</p>
                    </div>
                    <div class="shrink-0">
                        ${ratingHtml}
                    </div>
                </div>
                
                <div class="mt-4 flex flex-wrap gap-2">
                    ${genres.split(',').map(genre => 
                        `<span class="bg-gray-100 text-gray-700 px-3 py-1 rounded text-sm">${genre}</span>`
                    ).join('')}
                </div>
                
                <div class="mt-8">
                    <h2 class="text-xl font-semibold text-gray-800 mb-3 flex items-center">
                        <i class="fa fa-info-circle mr-2 text-primary"></i>剧情简介
                    </h2>
                    <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-100">
                        <p class="text-gray-700 leading-relaxed">${summary}</p>
                    </div>
                </div>
                
                <div class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 mb-3">导演</h3>
                        <p class="text-gray-700">${directors}</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 mb-3">主演</h3>
                        <p class="text-gray-700 cast-truncate" title="${casts}">${casts}</p>
                    </div>
                </div>
                
                ${customClassHtml}
                ${labelsHtml}
                ${groupItemsHtml}
                
                <div class="mt-8">
                    <h3 class="text-lg font-semibold text-gray-800 mb-4">文件信息</h3>
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
                        <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-100">
                            <h4 class="text-sm font-medium text-gray-500 mb-2">视频格式</h4>
                            <p class="text-gray-800">${videoFormat} (${quality})</p>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-100">
                            <h4 class="text-sm font-medium text-gray-500 mb-2">音频格式</h4>
                            <p class="text-gray-800">${audioFormat}</p>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-100">
                            <h4 class="text-sm font-medium text-gray-500 mb-2">文件大小</h4>
                            <p class="text-gray-800">${size}</p>
                        </div>
                        <div class="bg-white p-4 rounded-lg shadow-sm border border-gray-100">
                            <h4 class="text-sm font-medium text-gray-500 mb-2">存储位置</h4>
                            <p class="text-gray-800 truncate" title="${fileLocation}">${displayFileLocation}</p>
                        </div>
                    </div>
                    ${hasSubtitle ? `
                    <div class="mt-4">
                        <div class="bg-green-50 border border-green-200 p-4 rounded-lg flex items-center">
                            <i class="fa fa-file-text-o text-green-600 text-2xl mr-3"></i>
                            <div>
                                <h4 class="text-sm font-semibold text-green-800 mb-1">字幕文件</h4>
                                <p class="text-xs text-green-600">此影片包含字幕文件，支持外部播放器和内置播放器</p>
                            </div>
                        </div>
                    </div>
                    ` : ''}
                </div>
            </div>
        </div>
    `;
    
    document.getElementById('playBtn').addEventListener('click', playMovie);
    
    loadingIndicator.classList.add('hidden');
    errorState.classList.add('hidden');
    movieDetailContent.classList.remove('hidden');
}

function showLoadingState() {
    loadingIndicator.classList.remove('hidden');
    errorState.classList.add('hidden');
    movieDetailContent.classList.add('hidden');
}

function showErrorState() {
    loadingIndicator.classList.add('hidden');
    errorState.classList.remove('hidden');
    movieDetailContent.classList.add('hidden');
}

document.addEventListener('DOMContentLoaded', initPage);